<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class ContenutiGirevoli {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $classeElementi;
        private $aspectRatioElementi;
        private $mostraTitoloComponente;
        private $immaginiInBackground;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $classeElementi="", $aspectRatioElementi="", $mostraTitoloComponente="", $immaginiInBackground="") {
            $this->db             = $db;
            $this->id             = $id;
            $this->nome           = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->classeElementi = $classeElementi;
            $this->aspectRatioElementi    = $aspectRatioElementi;
            $this->mostraTitoloComponente = $mostraTitoloComponente;
            $this->immaginiInBackground   = $immaginiInBackground;
        }

        function crea() {
            $query    = "INSERT INTO geec_contenutiGirevoli VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->classeElementi','$this->aspectRatioElementi','$this->mostraTitoloComponente','$this->immaginiInBackground')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_contenutiGirevoli SET nome='$this->nome', mostraTitoloComponente='$this->mostraTitoloComponente', spazioOccupato='$this->spazioOccupato', classeElementi='$this->classeElementi', aspectRatioElementi='$this->aspectRatioElementi', immaginiInBackground='$this->immaginiInBackground' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_contenutiGirevoli",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 50
            eliminaOccorrenzeComponente($this->db,$this->id,24);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_contenutiGirevoli VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_singoliContenutiGirevoli WHERE idSezione='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_singoliContenutiGirevoli` (`id`, `idSezione`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_singoliContenutiGirevoli WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_singoliContenutiGirevoli SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_singoliContenutiGirevoli SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiGriglia   = $this->db->leggiSingolaRiga("geec_contenutiGirevoli",$this->id);
            $this->nome              = $datiGriglia["nome"];
            $this->spazioOccupato    = $datiGriglia["spazioOccupato"];
            $this->classeElementi    = $datiGriglia["classeElementi"];
            $this->aspectRatioElementi    = $datiGriglia["aspectRatioElementi"];
            $this->mostraTitoloComponente = $datiGriglia["mostraTitoloComponente"];
            $this->immaginiInBackground   = $datiGriglia["immaginiInBackground"];
        }
        
        function creaElemento($nome,$sfondoDivImmagine,$sfondoDivTesto) {
            $queryPosizione = "SELECT * FROM geec_singoliContenutiGirevoli WHERE idSezione=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
                    
            $query = "INSERT INTO `geec_singoliContenutiGirevoli` (`id`, `idSezione`, `classeElemento`, `nome`, `link`, `sfondoDivImmagine`, `coloreTestoDivImmagine`, `sfondoDivTesto`, `coloreTestoDivTesto`, `testo`, `immagine`, `etichetta`, `posizione`) 
                       VALUES (NULL, '$this->id', '', '$nome', '', '$sfondoDivImmagine', '', '$sfondoDivTesto', '', '', 'immagini/altro/segnaposto.png', '', '$posizione')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            $query = "SELECT * FROM geec_singoliContenutiGirevoli WHERE idSezione = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                $nomeEscape = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded">
                    <div class="form-row">
                        <div class="col-xl-3 mb-2 mb-xl-0">
                            <div class="aspect-ratio-21-9">
                                <img src="../../../<?php echo $elemento["immagine"] ?>">
                            </div> 
                        </div>
                        <div class="col-md-8 col-xl-5 align-self-center mb-2 mb-md-0">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["nome"] ?></strong></a></em></p>
                        </div>
                        <div class="col-md-4 col-xl-2 align-self-center">
                            <form>
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-xl-2 align-self-center text-right azioni">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $nomeEscape; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$nome,$link,$classeElemento,$sfondoDivTesto,$coloreTestoDivTesto,$sfondoDivImmagine,$coloreTestoDivImmagine,$testo,$etichetta) {
            $query = "UPDATE geec_singoliContenutiGirevoli SET nome='$nome', link='$link', classeElemento='$classeElemento', sfondoDivTesto='$sfondoDivTesto', coloreTestoDivTesto='$coloreTestoDivTesto', sfondoDivImmagine='$sfondoDivImmagine', coloreTestoDivImmagine='$coloreTestoDivImmagine', testo='$testo', etichetta='$etichetta' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaImmagineElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_singoliContenutiGirevoli` SET  immagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_singoliContenutiGirevoli WHERE idSezione=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_singoliContenutiGirevoli SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_singoliContenutiGirevoli SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_singoliContenutiGirevoli",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getClasseElementi() {
            return $this->classeElementi;
        }

        public function getAspectRatioElementi() {
            return $this->aspectRatioElementi;
        }

        public function getMostraTitoloComponente() {
            return $this->mostraTitoloComponente;
        }
        
        public function getImmaginiInBackground() {
            return $this->immaginiInBackground;
        }
        
        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setClasseElementi($classeElementi): void {
            $this->classeElementi = $classeElementi;
        }

        public function setAspectRatioElementi($aspectRatioElementi): void {
            $this->aspectRatioElementi = $aspectRatioElementi;
        }

        public function setMostraTitoloComponente($mostraTitoloComponente): void {
            $this->mostraTitoloComponente = $mostraTitoloComponente;
        }

        public function setImmaginiInBackground($immaginiInBackground): void {
            $this->immaginiInBackground = $immaginiInBackground;
        }

    }